/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package teamdev.jxcapture.samples.demo;

import org.jdesktop.application.Action;
import org.jdesktop.application.*;
import teamdev.jxdesktop.win32.shell.TrayIcon;
import teamdev.jxdesktop.win32.shell.TrayMessage;
import teamdev.jxdesktop.Keyboard;

import java.awt.*;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.*;

/**
 * @author Ikryanov Vladimir
 */
public class JxCaptureDemo extends SingleFrameApplication {

    private TrayIcon trayIcon;
    private InputStream inputStream;

    private Keyboard keyboard = Keyboard.createKeyboard();
    private KeyListener keyboardListener = new KeyListener();

    @Override
    protected void startup() {
        System.setProperty("javax.swing.adjustPopupLocationToFit", "false");

        ApplicationSettings.getInstance().loadSettings();

        if (SystemTray.isSupported()) {
            ApplicationContext appContext = Application.getInstance().getContext();
            ResourceMap resource = appContext.getResourceMap(JxCaptureDemo.class);
            String tooltip = resource.getString("TrayIcon.tooltip");
            String caption = resource.getString("TrayIcon.caption");
            String text = resource.getString("TrayIcon.text");

            trayIcon = new TrayIcon();
            trayIcon.setToolTip(tooltip);
            trayIcon.setIcon(getTrayIcon());
            trayIcon.setPopupMenu(new TrayPopupMenu());
            trayIcon.setVisible(true);
            trayIcon.showMessage(new TrayMessage.Info(caption, text));
        } else {
            showApplicationWindow();
        }

        keyboard.addKeyListener(keyboardListener);

        addExitListener(new ExitListener());
    }

    @Override
    protected void shutdown() {
        super.shutdown();
        if (trayIcon != null) {
            try {
                inputStream.close();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            trayIcon.setVisible(false);
            trayIcon.dispose();
            trayIcon = null;
        }

        keyboard.removeKeyListener(keyboardListener);
        keyboard.dispose();

        ApplicationSettings.getInstance().saveSettings();
    }

    @Action
    public void about() {
        AboutDialog.getInstance().setVisible(true);
    }

    @Action
    public void settings() {
        SettingsDialog.getInstance().setVisible(true);
    }

    @Action
    public void quit() {
        exit();
    }

    private teamdev.jxdesktop.win32.gdi.Icon getTrayIcon() {
        URL resource = JxCaptureDemo.class.getResource("resources/images/JxCapture.ico");
        try {
            inputStream = resource.openStream();
            return new teamdev.jxdesktop.win32.gdi.Icon(inputStream);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * If System tray is not supported the method display window with the same functionality.
     */
    private void showApplicationWindow() {
        throw new UnsupportedOperationException("JxCapture Demo window is not supported yet.");
    }

    private class ExitListener implements Application.ExitListener {
        public boolean canExit(EventObject e) {
            List<ImageViewer> activeViewers = CaptureOperations.getInstance().getActiveViewers();
            for (ImageViewer activeViewer : activeViewers) {
                if (!activeViewer.close()) return false;
            }
            return true;
        }

        public void willExit(EventObject e) {
        }
    }

    private class KeyListener extends KeyAdapter {
        
        private CaptureOperations operations = CaptureOperations.getInstance();

        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() && e.isShiftDown() && !operations.isBusy()) {
                switch (e.getKeyCode()) {
                    case KeyEvent.VK_A:
                        operations.activeWindowCapture();
                        break;
                    case KeyEvent.VK_W:
                        operations.objectCapture();
                        break;
                    case KeyEvent.VK_R:
                        operations.regionCapture();
                        break;
                    case KeyEvent.VK_F:
                        operations.desktopCapture();
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        launch(JxCaptureDemo.class, args);
    }
}
